
[Programming learning tools](https://www.linkedin.com/posts/neilhoyne_google-lifeatgoogle-programming-activity-7265394340212920321-Q18U)

### Object-Oriented Programming (OOP): Code basics
- **Class** is a blueprint from which individual objects are created. Class defines the possible states and behaviors so that any object created as an instance of a class will follow these definitions to interact with outside world.
	- E.g. Bicycle is a class. MountainBike, RoadBike are objects - they are subtype/instance of the class Bicycle and will always follow definition of a Bicycle.
- **Object** is an instance of a class. Objects have state and behavior. The state is stores in fields/variables and exposes its behavior through methods/functions.
	- E.g. MountainBike will have currentSpeed, currentGear as states and gearUp, gearDown, brakeOn, brakeOff as methods that will affect its states.
- **Inheritence** OOP allows classes to inherit commonly used state and behavior from other classes.
	- E.g. Bicycle is superclass of MountainBike and RoadBike objects so that objects will inherit common elements of the Bicycle class. MountainBike has all the same fields and methods as Bicycle, yet allows its code to focus exclusively on the features that make it unique.
- **Interface** - Objects define their interaction with outside world through the methods that they expose. Methods are the object's interface with outside world. Interfaces form a contract between the class and outside world, the contract is enforced at build time by the compiler.
	- E.g. Buttons on TV remote

### Data structure
- Arrays
- Linked lists
- Stacks
- Queues
- Trees
- Graphs
- Hash tables
- Trie
- Hash maps
- B-trees

### Programming languages
- Python
- C
- Java